-- Query for vtt_event data
SELECT
    ve.vtt_timestart AS event_timestart,
    ve.vtt_timeend AS event_timeend,
    ve.vtt_eventdate AS event_date,
    ve.staff_pk AS staff_no
FROM
    vtt_event ve
    INNER JOIN staff_info si ON si.staff_pk = ve.staff_pk
WHERE
    ve.vtt_eventdate = '$vtt_eventdate'
    AND
    ve.staff_pk = '$staff_pk'

UNION

-- Query for vtt_meeting data
SELECT 
    vm.meeting_timestart AS event_timestart,        -- Meeting start time
    vm.meeting_timeend AS event_timeend,          -- Meeting end time
    vm.meeting_date AS event_date,              -- Meeting date
    vm.staff_pk AS staff_no
FROM
    vtt_meeting vm
    INNER JOIN staff_info si ON si.staff_pk = vm.staff_pk
WHERE
    vm.meeting_date = '$meeting_date'
    AND
    vm.staff_pk = '$staff_pk'


UNION


-- Query for vtt_nonprojectevent data
SELECT 
    bpe.nonproject_starthour AS event_timestart,        -- vtt_nonprojectevent start time
    bpe.nonproject_endhour AS event_timeend,          -- vtt_nonprojectevent end time
    bpe.nonproject_eventdate AS event_date,              -- vtt_nonprojectevent date
    bpe.staff_pk AS staff_no
FROM
    vtt_nonprojectevent bpe
    INNER JOIN staff_info si ON si.staff_pk = bpe.staff_pk
WHERE
    bpe.nonproject_eventdate = '$nonproject_eventdate'
AND 
    bpe.staff_pk = '$staff_pk'


UNION


SELECT
    vl.leave_starthour AS event_timestart,
    vl.leave_endhour AS event_timeend,
    vle.leave_startdate AS event_date,
    vle.staff_pk AS staff_no
FROM
    vtt_leaveevent vle
    INNER JOIN vtt_leave vl ON vl.vttleave_pk = vle.vttleave_pk
    INNER JOIN staff_info si ON si.staff_pk = vle.staff_pk
WHERE
	vle.leave_startdate = '$leave_startdate'
AND
	vle.staff_pk = '$staff_pk'

ORDER BY event_timestart
DESC
LIMIT 1
